/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./extends.js":
/*!********************!*\
  !*** ./extends.js ***!
  \********************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
/* extends.js

    Purpose:
        
    Description:
        
    History:
        1:02 PM 2023/8/21, Created by jumperchen

Copyright (C) 2023 Potix Corporation. All Rights Reserved.
*/
var extendStatics = function (d, b) {
  extendStatics = Object.setPrototypeOf || {
    __proto__: []
  } instanceof Array && function (d, b) {
    d.__proto__ = b;
  } || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
  };
  return extendStatics(d, b);
};
// refer tslib#__extends
function default_1(d, b) {
  extendStatics(d, b);
  function __() {
    this.constructor = d;
  }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  d.prototype._$super = d.name == '$subclass$' && b.prototype._$super ? b.prototype._$super : b.prototype; // Potix: Jumper Chen adds to support `$supers(foo.Bar, 'bind_')`
}
exports["default"] = default_1;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/menu/Menu.ts":
/*!********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/menu/Menu.ts ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ContentHandler = exports.Menu = void 0;
/* Menu.ts

    Purpose:

    Description:

    History:
        Thu Jan 15 09:02:33     2009, Created by jumperchen

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
function _toggleClickableCSS(wgt, remove) {
  if (wgt.isListen('onClick')) {
    jq(wgt.$n_())[remove ? 'removeClass' : 'addClass'](wgt.$s('hover'));
  }
}
function _doClick(wgt, evt) {
  var byKeyboard = evt.name == 'onKeyDown',
    n = wgt.$n_();
  if (wgt.isListen('onClick')) {
    var clk = jq(n).find('.' + wgt.$s('separator')),
      zclk = zk(clk),
      offsetX = zclk.revisedOffset()[0];
    //Bug ZK-1357: minus 10px for easily open menupopup when click near arrow icon
    if (jq(n).hasClass('z-menu-clickable') && evt.pageX > offsetX) {
      jq(n).addClass(wgt.$s('selected'));
      wgt.menupopup._shallClose = false;
      wgt._togglePopup(byKeyboard);
      evt.stop();
    } else wgt.fireX(new zk.Event(wgt, 'onClick', evt.data));
  } else {
    jq(n).addClass(wgt.isTopmost() ? wgt.$s('selected') : wgt.$s('hover'));
    wgt.menupopup._shallClose = false;
    wgt._togglePopup(byKeyboard);
  }
}
function _isActiveItem(wgt) {
  return wgt.isVisible() && wgt instanceof zul.menu.Menu && !wgt.isDisabled();
}
function _nextVisibleMenu(menu) {
  for (var m = menu; m; m = m.nextSibling) {
    if (_isActiveItem(m)) return m;
  }
  var mb = menu.parent;
  if (mb.firstChild == menu) return menu;
  return _nextVisibleMenu(mb.firstChild);
}
function _prevVisibleMenu(menu) {
  for (var m = menu; m; m = m.previousSibling) {
    if (_isActiveItem(m)) return m;
  }
  var mb = menu.parent;
  if (mb.lastChild == menu) return menu;
  return _prevVisibleMenu(mb.lastChild);
}
/**
 * An element, much like a button, that is placed on a menu bar.
 * When the user clicks the menu element, the child {@link Menupopup}
 * of the menu will be displayed.
 * This element is also used to create submenus (of {@link Menupopup}.
 *
 * @defaultValue {@link getZclass}: z-mean.
 */
var Menu = /** @class */function (_super) {
  __extends(Menu, _super);
  function Menu() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._topmost = false;
    /** @internal */
    _this._disabled = false;
    return _this;
  }
  Menu_1 = Menu;
  /**
   * @returns the embedded content (i.e., HTML tags) that is shown as part of the description.
   * <p>It is useful to show the description in more versatile way.
   * @defaultValue empty ("").
   */
  Menu.prototype.getContent = function () {
    return this._content;
  };
  /**
   * Sets the embedded content (i.e., HTML tags) that is
   * shown as part of the description.
   *
   * <p>It is useful to show the description in more versatile way.
   *
   * <p>There is a way to create {@link zkex.inp.Colorbox} automatically by using
   * `#color=#RRGGBB`, usage example `setContent("#color=FFFFFF")`
   */
  Menu.prototype.setContent = function (content, opts) {
    var o = this._content;
    this._content = content;
    if (o !== content || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (!content || content.length == 0) return this;
      if (!this._contentHandler) {
        if (zk.feature.pe) {
          var self = this;
          zk.load('zkex.inp', undefined, function () {
            self._contentHandler = new zkex.inp.ContentHandler(self, content);
          });
          return this;
        }
        this._contentHandler = new zul.menu.ContentHandler(this, content);
      } else this._contentHandler.setContent(content);
    }
    return this;
  };
  /**
   * @returns whether it is disabled.
   * @defaultValue `false`.
   * @since 8.0.3
   */
  Menu.prototype.isDisabled = function () {
    return this._disabled;
  };
  /**
   * Sets whether it is disabled.
   * @since 8.0.3
   */
  Menu.prototype.setDisabled = function (disabled, opts) {
    var o = this._disabled;
    this._disabled = disabled;
    if (o !== disabled || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (!this.desktop) return this;
      if (disabled) {
        jq(this.$n_('a')).attr('disabled', 'disabled').attr('tabindex', '-1');
      } else {
        jq(this.$n_('a')).removeAttr('disabled').removeAttr('tabindex');
      }
    }
    return this;
  };
  Menu.prototype.getImage = function () {
    return this._image;
  };
  Menu.prototype.setImage = function (image, opts) {
    var o = this._image;
    this._image = image;
    if (o !== image || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (image && this._preloadImage) zUtl.loadImage(image);
      this.rerender();
    }
    return this;
  };
  /**
   * Opens the menupopup that belongs to the menu.
   * <p>
   * Note that this function is only applied when it is topmost menu, i.e. the parent of the menu is {@link Menubar}
   * @since 6.0.0
   */
  Menu.prototype.open = function () {
    if (this.desktop && this.isTopmost()) {
      jq(this.$n_()).addClass(this.$s('selected'));
      var mb = this.getMenubar();
      if (mb._lastTarget) this.$class._rmActive(mb._lastTarget);
      mb._lastTarget = this;
      this.menupopup._shallClose = false;
      this._togglePopup();
    }
  };
  // since ZK 6.5.0 internal use only.
  /** @internal */
  Menu.prototype.getAnchor_ = function () {
    return this.$n('a');
  };
  /** @internal */
  Menu.prototype.domContent_ = function () {
    var label = '<span class="' + this.$s('text') + '">' + zUtl.encodeXML(this.getLabel()) + '</span>',
      img = this.getImage(),
      icon = '<i class="' + this.$s('icon') + ' z-icon-caret-' + (this.isTopmost() && !this.isVertical_() ? 'down' : 'right') + '" aria-hidden="true"></i>',
      separator = '<div class="' + this.$s('separator') + '" aria-hidden="true"></div>',
      /*safe*/iconSclass = this.domIcon_();
    if (img) /*safe*/img = '<img id="' + this.uuid + '-img" src="' + /*safe*/img + '" class="' + this.$s('image') + '" align="absmiddle" alt="" aria-hidden="true" />' + (iconSclass ? ' ' + /*safe*/iconSclass : '');else {
      if (iconSclass) {
        img = iconSclass;
      } else {
        /*safe*/img = '<img id="' + this.uuid + '-img" ' + (this.isTopmost() ? 'style="display:none"' : '') + ' src="data:image/png;base64,R0lGODlhAQABAIAAAAAAAAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="' + this.$s('image') + '" align="absmiddle" alt="" aria-hidden="true" />';
      }
    }
    return DOMPurify.sanitize(img + label + separator + icon);
  };
  /**
   * @returns whether this is an top-level menu, i.e., not owning
   * by another {@link Menupopup}.
   */
  Menu.prototype.isTopmost = function () {
    return this._topmost;
  };
  /** @internal */
  Menu.prototype.beforeParentChanged_ = function (newParent) {
    this._topmost = !!newParent && !(newParent instanceof zul.menu.Menupopup);
    _super.prototype.beforeParentChanged_.call(this, newParent);
  };
  /** @internal */
  Menu.prototype.onChildAdded_ = function (child) {
    _super.prototype.onChildAdded_.call(this, child);
    if (child instanceof zul.menu.Menupopup) {
      this.menupopup = child;
      if (this._contentHandler) this._contentHandler.destroy();
    }
  };
  /** @internal */
  Menu.prototype.onChildRemoved_ = function (child) {
    _super.prototype.onChildRemoved_.call(this, child);
    if (child == this.menupopup) {
      this.menupopup = undefined;
      if (this._contentHandler) this._contentHandler.setContent(this._content);
    }
  };
  /**
   * @returns the {@link Menubar} that contains this menu, or null if not available.
   */
  Menu.prototype.getMenubar = function () {
    for (var p = this.parent; p; p = p.parent) {
      if (p instanceof zul.menu.Menubar) return p;
      if (!(p instanceof zul.menu.Menupopup || p instanceof zul.menu.Menu)) break; // not found
    }
    return undefined;
  };
  Menu.prototype.onShow = function () {
    if (this._contentHandler) this._contentHandler.onShow();
  };
  Menu.prototype.onFloatUp = function (ctl) {
    if (this._contentHandler) this._contentHandler.onFloatUp(ctl);
  };
  Menu.prototype.onHide = function () {
    if (this._contentHandler) this._contentHandler.onHide();
  };
  /** @internal */
  Menu.prototype.focus_ = function (timeout, ignoreActive /* used for Menupopup.js*/) {
    if (this.isTopmost() && zk(this.getAnchor_()).focus(timeout)) {
      // fixed for pressing TAB key from menupopup when the menupopup
      // is the last one, in IE it will delay to show the active effect.
      // We have to use the ignoreActive to avoid adding the active effect
      // to the menu widget.
      if (ignoreActive) {
        this._ignoreActive = true;
      }
      return true;
    }
    return _super.prototype.focus_.call(this, timeout);
  };
  // used for Menupopup.js
  /** @internal */
  Menu.prototype._getPrevVisibleMenu = function () {
    var prev = this.previousSibling;
    if (!prev) {
      var mb = this.getMenubar();
      if (mb) prev = mb.lastChild;
    }
    return prev ? _prevVisibleMenu(prev) : this;
  };
  // used for Menupopup.js
  /** @internal */
  Menu.prototype._getNextVisibleMenu = function () {
    var next = this.nextSibling;
    if (!next) {
      var mb = this.getMenubar();
      if (mb) next = mb.firstChild;
    }
    return next ? _nextVisibleMenu(next) : this;
  };
  /** @internal */
  Menu.prototype.doKeyDown_ = function (evt) {
    // only support for the topmost menu
    if (this.isTopmost()) {
      var keyCode = evt.keyCode;
      // switch the navigation key when in vertical view
      if (this.isVertical_()) {
        switch (keyCode) {
          case 38:
            //UP
            keyCode = 37;
            break;
          case 40:
            //DOWN
            keyCode = 39;
            break;
          case 37:
            //LEFT
            keyCode = 38;
            break;
          case 39:
            //RIGHT
            keyCode = 40;
            break;
        }
      }
      switch (keyCode) {
        case 38:
          //UP
          // 1. close the menupopup if any.
          // 2. make the menu as focus effect
          var pp = this.menupopup;
          if (pp && pp.isOpen()) {
            jq(this.$n_()).removeClass(this.$s('hover')).removeClass(this.$s('selected'));
            pp.close();
          }
          this.$class._addActive(this, 'focus'); // keep the focus
          evt.stop();
          break;
        case 40:
          //DOWN
          // 1. open menupopup if any.
          // 2. pass the focus control to menupopup
          if (this.menupopup && !this._disabled) {
            jq(this.$n_()).addClass(this.$s('selected')).removeClass(this.$s('hover'));
            this.menupopup._shallClose = false;
            this.menupopup.open(undefined, undefined, undefined, {
              focusFirst: true,
              sendOnOpen: true,
              disableMask: true
            });
          }
          evt.stop();
          break;
        case 13: //ENTER
        case 32:
          //SPACE
          // 1. toggle the open/close status for the menupopup, if any.
          if (this.menupopup) _doClick(this, evt);
          evt.stop();
          break;
        case 9:
          // 1. deactive this menu, then it will jump to the next focus target.
          this.$class._rmActive(this);
          break;
      }
    }
    _super.prototype.doKeyDown_.call(this, evt);
  };
  /** @internal */
  Menu.prototype.doFocus_ = function (evt) {
    if (this.isTopmost()) {
      var menubar = this.getMenubar(),
        $menu = this.$class;
      // clear the previous active target, if any.
      if (menubar && menubar._lastTarget) $menu._rmActive(menubar._lastTarget);
      if (!this._ignoreActive) $menu._addActive(this, 'focus');
    }
    // delete the variable used for IE
    delete this._ignoreActive;
    _super.prototype.doFocus_.call(this, evt);
  };
  /** @internal */
  Menu.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    var anc = this.getAnchor_();
    this.domListen_(anc, 'onFocus', 'doFocus_') // used to handle keystroke
    .domListen_(anc, 'onBlur', 'doBlur_').domListen_(anc, 'onMouseEnter').domListen_(anc, 'onMouseLeave');
    if (this.isTopmost() && this.isListen('onClick')) {
      jq(this.$n_()).addClass(this.$s('clickable'));
    }
    if (this._contentHandler) this._contentHandler.bind();
  };
  /** @internal */
  Menu.prototype.unbind_ = function (skipper, after, keepRod) {
    var anc = this.getAnchor_();
    this.domUnlisten_(anc, 'onFocus', 'doFocus_').domUnlisten_(anc, 'onBlur', 'doBlur_').domUnlisten_(anc, 'onMouseEnter').domUnlisten_(anc, 'onMouseLeave');
    if (this._contentHandler) this._contentHandler.unbind();
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  // used for overriding from different theme
  /** @internal */
  Menu.prototype._getArrowWidth = function () {
    return 20;
  };
  /** @internal */
  Menu.prototype._showContentHandler = function () {
    var content = this._contentHandler;
    if (content && !content.isOpen()) content.onShow();
  };
  /** @internal */
  Menu.prototype._hideContentHandler = function () {
    var content = this._contentHandler;
    if (content && content.isOpen()) {
      content.onHide();
      if (this.isTopmost()) this.focus();else this.parent.focus();
    }
  };
  /** @internal */
  Menu.prototype.doClick_ = function (evt, popupOnly) {
    if (!this._disabled) {
      if (this.menupopup) {
        if (this.isTopmost()) this.getMenubar()._lastTarget = this;
        // toggle the open/close status of menupopup/contenthandler
        _doClick(this, evt);
      } else {
        this._showContentHandler();
      }
    }
    evt.stop();
  };
  /** @internal */
  Menu.prototype.doMouseOver_ = function (evt) {
    if (!this.isTopmost()) {
      this._showContentHandler();
    }
    _super.prototype.doMouseOver_.call(this, evt);
  };
  /** @internal */
  Menu.prototype._togglePopup = function (byKeyboard) {
    // show the content handler
    if (!this.menupopup && this._contentHandler) {
      this._showContentHandler();
    } else {
      if (!this.menupopup.isOpen()) {
        if (this.isTopmost()) _toggleClickableCSS(this);
        this.menupopup.open(undefined, undefined, undefined, {
          focusFirst: byKeyboard,
          sendOnOpen: true,
          disableMask: true
        });
      } else if (this.isTopmost()) this.menupopup.close({
        sendOnOpen: true
      });else zk(this.menupopup.$n('a')).focus(); // force to get a focus
    }
  };
  /** @internal */
  Menu.prototype._doMouseEnter = function (evt) {
    var menubar = this.getMenubar();
    if (menubar) {
      menubar._noFloatUp = false;
    }
    if (this._disabled) return;
    var topmost = this.isTopmost();
    if (topmost) _toggleClickableCSS(this);
    if (this.menupopup) this.menupopup._shallClose = false;
    if (!topmost) {
      zWatch.fire('onFloatUp', this); //notify all
      if (this.menupopup && !this.menupopup.isOpen()) this.menupopup.open();
      // FIXME: Only Menupopup defines `removeActive_`, but shouldn't the parent be a Menubar?
      this.parent.removeActive_();
    } else {
      // NOTE: It has always been the case that menubar is assumed to exist in this branch,
      // i.e., if `topmost` holds, but menubar is tested for nullity in the beginning of this
      // function, i.e., `if (menubar) { menubar._noFloatUp = false; }`. Is this intended?
      if (this.menupopup && menubar._autodrop) {
        zWatch.fire('onFloatUp', this); //notify all
        if (!this.menupopup.isOpen()) this.menupopup.open();
      } else {
        var target = menubar._lastTarget;
        if (target && target != this) {
          this.$class._rmActive(target);
          if (target.menupopup && target.menupopup.isVisible()) {
            target.menupopup.close({
              sendOnOpen: true
            });
            if (this.menupopup) this.menupopup.open();
          }
        }
      }
    }
    this.$class._addActive(this, 'hover');
  };
  /** @internal */
  Menu.prototype._doMouseLeave = function (evt) {
    var menubar = this.getMenubar();
    this._updateHoverImage(); // remove hover image if any
    if (this._disabled) return;
    var topmost = this.isTopmost(),
      menupopup = this.menupopup;
    if (topmost) {
      //implies menubar
      this.$class._rmActive(this, true);
      if (menupopup && menubar._autodrop) {
        if (menupopup.isOpen()) menupopup._shallClose = true; //autodrop -> autoclose if mouseout
      }
    } else if (!menupopup || !menupopup.isOpen()) this.$class._rmActive(this);
  };
  Menu.prototype.getImageNode = function () {
    if (!this._eimg && (this._image || this._hoverImage)) {
      var n = this.$n();
      if (n) this._eimg = this.$n_('a').firstChild;
    }
    return this._eimg;
  };
  /** @internal */
  Menu.prototype.ignoreDescendantFloatUp_ = function (des) {
    return des && des instanceof zul.menu.Menupopup;
  };
  /** @internal */
  Menu.prototype.isVertical_ = function () {
    if (this.isTopmost()) {
      var bar = this.getMenubar();
      if (bar) return bar.isVertical();
    }
    return false;
  };
  /** @internal */
  Menu._isActive = function (wgt, type) {
    var top = wgt.isTopmost(),
      n = wgt.$n_(),
      menupopup = wgt.menupopup,
      cls = top ? menupopup && menupopup.isOpen() ? wgt.$s('selected') : wgt.$s(type) : wgt.$s(type);
    return jq(n).hasClass(cls);
  };
  /** @internal */
  Menu._addActive = function (wgt, type) {
    var top = wgt.isTopmost(),
      n = wgt.$n_(),
      menupopup = wgt.menupopup,
      cls = top ? menupopup && menupopup.isOpen() ? wgt.$s('selected') : wgt.$s(type) : wgt.$s(type);
    jq(n).addClass(cls);
    if (top) {
      var mb = wgt.getMenubar();
      if (mb) mb._lastTarget = wgt;
    } else if (wgt.parent instanceof zul.menu.Menupopup) {
      var parentMenupopup = wgt.parent;
      parentMenupopup.addActive_(wgt);
      if (parentMenupopup.parent instanceof zul.menu.Menu) this._addActive(parentMenupopup.parent, type);
    }
  };
  /** @internal */
  Menu._rmActive = function (wgt, ignoreSeld /* used for mouseout when topmost*/) {
    var top = wgt.isTopmost(),
      n = wgt.$n_(),
      menupopup = wgt.menupopup,
      anode = top && !ignoreSeld && menupopup && menupopup.isOpen() ? jq(n).removeClass(wgt.$s('selected')) : jq(n).removeClass(wgt.$s('hover')).removeClass(wgt.$s('focus'));
    if (top && !(anode.hasClass(wgt.$s('selected')) || anode.hasClass(wgt.$s('hover')) || anode.hasClass(wgt.$s('focus')))) _toggleClickableCSS(wgt, true);
  };
  // Prior to TS migration, this method was accidentally declared in ContentHandler.
  /** @internal */
  Menu.prototype.deferRedrawHTML_ = function (out) {
    out.push('<li', this.domAttrs_({
      domClass: true
    }), ' class="z-renderdefer"></li>');
  };
  var Menu_1;
  Menu = Menu_1 = __decorate([zk.WrapClass('zul.menu.Menu')], Menu);
  return Menu;
}(zul.LabelImageWidget);
exports.Menu = Menu;
var ContentHandler = /** @class */function (_super) {
  __extends(ContentHandler, _super);
  function ContentHandler(wgt, content) {
    var _this = _super.call(this) || this;
    _this._wgt = wgt;
    _this._content = content;
    return _this;
  }
  ContentHandler.prototype.setContent = function (content) {
    if (this._content != content || !this._pp) {
      this._content = content;
      this._wgt.rerender();
    }
    return this;
  };
  ContentHandler.prototype.redraw = function (out) {
    var wgt = this._wgt;
    out.push('<div id="', /*safe*/wgt.uuid, '-cnt-pp" class="', wgt.$s('content-popup'), '" style=""><div class="', wgt.$s('content-body'), '">', DOMPurify.sanitize(this._content), '</div></div>');
  };
  ContentHandler.prototype.bind = function () {
    var wgt = this._wgt;
    if (!wgt.menupopup) {
      wgt.domListen_(wgt.$n_(), 'onClick', 'onShow');
      zWatch.listen({
        onFloatUp: wgt,
        onHide: wgt
      });
    }
    this._pp = wgt.$n('cnt-pp');
    jq(this._pp, zk).on('mouseenter', this.proxy(this._doMouseEnter)).on('mouseleave', this.proxy(this._doMouseLeave));
  };
  ContentHandler.prototype.unbind = function () {
    var wgt = this._wgt;
    if (!wgt.menupopup) {
      if (this._shadow) {
        this._shadow.destroy();
        this._shadow = undefined;
      }
      wgt.domUnlisten_(wgt.$n_(), 'onClick', 'onShow');
      zWatch.unlisten({
        onFloatUp: wgt,
        onHide: wgt
      });
    }
    jq(this._pp, zk).off('mouseenter', this.proxy(this._doMouseEnter)).off('mouseleave', this.proxy(this._doMouseLeave));
    this._pp = undefined;
  };
  ContentHandler.prototype.isOpen = function () {
    var pp = this._pp;
    return !!pp && zk(pp).isVisible();
  };
  /** @internal */
  ContentHandler.prototype._doMouseEnter = function () {
    var menubar = this._wgt.getMenubar();
    if (menubar) menubar._bOver = true;
  };
  /** @internal */
  ContentHandler.prototype._doMouseLeave = function () {
    var menubar = this._wgt.getMenubar();
    if (menubar) menubar._bOver = false;
  };
  ContentHandler.prototype.onShow = function () {
    var wgt = this._wgt,
      pp = this._pp;
    if (!pp) return;
    pp.style.display = 'block';
    jq(pp).zk.makeVParent();
    zWatch.fireDown('onVParent', this);
    zk(pp).position(wgt.$n_(), this.getPosition());
    this.syncShadow();
  };
  ContentHandler.prototype.onHide = function () {
    var pp = this._pp;
    if (!pp || !zk(pp).isVisible()) return;
    pp.style.display = 'none';
    jq(pp).zk.undoVParent();
    zWatch.fireDown('onVParent', this);
    this.hideShadow();
  };
  ContentHandler.prototype.onFloatUp = function (ctl) {
    if (!zUtl.isAncestor(this._wgt, ctl.origin)) this.onHide();
  };
  ContentHandler.prototype.syncShadow = function () {
    if (!this._shadow) this._shadow = new zk.eff.Shadow(this._wgt.$n_('cnt-pp'), {
      stackup: zk.useStackup
    });
    this._shadow.sync();
  };
  ContentHandler.prototype.hideShadow = function () {
    if (this._shadow) this._shadow.hide();
  };
  ContentHandler.prototype.destroy = function () {
    this._wgt.rerender();
  };
  ContentHandler.prototype.getPosition = function () {
    var wgt = this._wgt;
    return wgt.isVertical_() ? 'end_before' : 'after_start';
  };
  ContentHandler = __decorate([zk.WrapClass('zul.menu.ContentHandler')], ContentHandler);
  return ContentHandler;
}(zk.Object);
exports.ContentHandler = ContentHandler;
if (!window.zul) window.zul = {};
if (!window.zul.menu) window.zul.menu = {};
if (!window.zul.menu.Menu) window.zul.menu.Menu = {};
window.zul.menu.Menu._ = {
  _toggleClickableCSS: _toggleClickableCSS,
  _doClick: _doClick,
  _isActiveItem: _isActiveItem,
  _nextVisibleMenu: _nextVisibleMenu,
  _prevVisibleMenu: _prevVisibleMenu,
  Menu: Menu,
  ContentHandler: ContentHandler
};

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/menu/Menubar.ts":
/*!***********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/menu/Menubar.ts ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Menubar = void 0;
/* Menubar.ts

    Purpose:

    Description:

    History:
        Thu Jan 15 09:02:32     2009, Created by jumperchen

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * The menu related widgets, such as menubar and menuitem.
 * @internal
 */
//zk.$package('zul.menu');
function _closeOnOut(menubar) {
  //1) _noFloatUp: Bug 1852304: Safari/Chrome unable to popup with menuitem
  //   because popup causes mouseout, and mouseout casues onfloatup
  //2) _bOver: indicates whether it is over some part of menubar
  //3) Test also Bug 3052208
  if (!menubar._noFloatUp && !menubar._bOver && zul.menu._nOpen) zWatch.fire('onFloatUp', menubar); //notify all
}
/**
 * A container that usually contains menu elements.
 *
 * @defaultValue {@link getZclass}: z-menubar
 */
var Menubar = /** @class */function (_super) {
  __extends(Menubar, _super);
  function Menubar() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._orient = 'horizontal';
    /** @internal */
    _this._bodyScrollLeft = 0;
    return _this;
  }
  Menubar_1 = Menubar;
  /**
   * @returns the orient.
   * @defaultValue `"horizontal"`.
   */
  Menubar.prototype.getOrient = function () {
    return this._orient;
  };
  /**
   * Sets the orient.
   * @param orient - either horizontal or vertical
   */
  Menubar.prototype.setOrient = function (orient, opts) {
    var o = this._orient;
    this._orient = orient;
    if (o !== orient || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.rerender();
    }
    return this;
  };
  /**
   * @returns whether the menubar scrolling is enabled.
   * @defaultValue `false`.
   */
  Menubar.prototype.isScrollable = function () {
    return !!this._scrollable;
  };
  /**
   * Sets whether to enable the menubar scrolling
   */
  Menubar.prototype.setScrollable = function (scrollable, opts) {
    var o = this._scrollable;
    this._scrollable = scrollable;
    if (o !== scrollable || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.checkScrollable()) this.rerender();
    }
    return this;
  };
  /**
   * @returns whether to automatically drop down menus if user moves mouse over it.
   * @defaultValue `false`.
   */
  Menubar.prototype.isAutodrop = function () {
    return !!this._autodrop;
  };
  /**
   * Sets whether to automatically drop down menus if user moves mouse over it.
   */
  Menubar.prototype.setAutodrop = function (autodrop) {
    this._autodrop = autodrop;
    return this;
  };
  Menubar.prototype.setWidth = function (width) {
    _super.prototype.setWidth.call(this, width);
    this._checkScrolling();
    return this;
  };
  /** @internal */
  Menubar.prototype.domClass_ = function (no) {
    var /*safe*/sc = _super.prototype.domClass_.call(this, no);
    if (!no || !no.zclass) {
      sc += ' ' + this.$s(this.isVertical() ? 'vertical' : 'horizontal');
    }
    return sc;
  };
  /** @internal */
  Menubar.prototype.unbind_ = function (skipper, after, keepRod) {
    if (this.checkScrollable()) {
      var left = this.$n('left'),
        right = this.$n('right');
      if (left && right) {
        this.domUnlisten_(left, 'onClick', '_doScroll').domUnlisten_(right, 'onClick', '_doScroll');
      }
      zWatch.unlisten({
        onSize: this
      });
    }
    var n = this.$n_();
    n.removeEventListener('mouseleave', this.proxy(this._doMouseLeave));
    n.removeEventListener('mouseenter', this.proxy(this._doMouseEnter));
    this._lastTarget = undefined;
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /** @internal */
  Menubar.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    var n = this.$n_();
    n.addEventListener('mouseenter', this.proxy(this._doMouseEnter));
    n.addEventListener('mouseleave', this.proxy(this._doMouseLeave));
    if (this.checkScrollable()) {
      var left = this.$n('left'),
        right = this.$n('right');
      if (left && right) {
        this.domListen_(left, 'onClick', '_doScroll').domListen_(right, 'onClick', '_doScroll');
      }
      zWatch.listen({
        onSize: this
      });
    }
  };
  /**
   * @returns whether the menubar scrolling is enabled in horizontal orient.
   */
  Menubar.prototype.checkScrollable = function () {
    return !!this._scrollable && !this.isVertical();
  };
  Menubar.prototype.onSize = function () {
    this._checkScrolling();
  };
  /** @internal */
  Menubar.prototype.onChildAdded_ = function (child) {
    _super.prototype.onChildAdded_.call(this, child);
    this._checkScrolling();
  };
  /** @internal */
  Menubar.prototype.onChildRemoved_ = function (child) {
    _super.prototype.onChildRemoved_.call(this, child);
    if (!this.childReplacing_) this._checkScrolling();
  };
  /** @internal */
  Menubar.prototype._checkScrolling = function () {
    if (!this.checkScrollable()) return;
    var node = this.$n();
    if (!node) return;
    jq(node).addClass(this.$s('scroll'));
    var nodeWidth = zk(node).contentWidth(),
      body = this.$n_('body'),
      children = jq(this.$n_('cave')).children().filter(':visible'),
      childrenLen = children.length,
      totalWidth = 0;
    for (var i = childrenLen; i--;) totalWidth += jq(children[i]).outerWidth(true); //ZK-3095
    if (totalWidth >= nodeWidth) this._scrolling = true;else {
      this._scrolling = false;
      this._fixBodyScrollLeft(0);
      //ZK-3094: Scrollable menubar body is not properly resized after container resizing.
      body.style.width = '';
    }
    this._fixButtonPos(node);
    var fixedSize = nodeWidth - zk(this.$n('left')).offsetWidth() - zk(this.$n('right')).offsetWidth();
    if (this._scrolling) {
      body.style.width = jq.px0(fixedSize);
      this._fixScrollPos(children.last()[0]);
    }
  };
  /** @internal */
  Menubar.prototype._fixScrollPos = function (lastChild) {
    if (lastChild) {
      var offsetLeft = lastChild.offsetLeft;
      if (offsetLeft < this._bodyScrollLeft) {
        this._fixBodyScrollLeft(offsetLeft);
      }
    }
  };
  /** @internal */
  Menubar.prototype._fixButtonPos = function (node) {
    var body = this.$n_('body'),
      left = this.$n_('left'),
      right = this.$n_('right'),
      css = this._scrolling ? 'addClass' : 'removeClass';
    left.style.display = right.style.display = this._scrolling ? 'block' : 'none';
    jq(node)[css](this.$s('scroll'));
    body.style.marginLeft = this._scrolling ? jq.px(left.offsetWidth) : '0';
    body.style.marginRight = this._scrolling ? jq.px(right.offsetWidth) : '0';
  };
  /** @internal */
  Menubar.prototype._forceStyle = function (node, value) {
    if (zk.parseInt(value) < 0) return;
    node.style.width = value;
  };
  /** @internal */
  Menubar.prototype._doMouseEnter = function (evt) {
    this._bOver = true;
    this._noFloatUp = false;
  };
  /** @internal */
  Menubar.prototype._doMouseLeave = function (evt) {
    this._bOver = false;
    this._closeOnOut();
  };
  /** @internal */
  Menubar.prototype._doScroll = function (evt) {
    this._scroll(evt.domTarget == this.$n('left') || evt.domTarget.parentNode == this.$n('left') ? 'left' : 'right');
  };
  /** @internal */
  Menubar.prototype._fixBodyScrollLeft = function (scrollLeft) {
    this.$n_('body').scrollLeft = this._bodyScrollLeft = scrollLeft;
  };
  /** @internal */
  Menubar.prototype._scroll = function (direction) {
    var _this = this;
    if (!this.checkScrollable() || this._runId) return;
    var body = this.$n_('body'),
      currScrollLeft = this._bodyScrollLeft,
      children = jq(this.$n_('cave')).children().filter(':visible'),
      childrenLen = children.length,
      movePos = 0;
    if (!childrenLen) return;
    switch (direction) {
      case 'left':
        for (var i = 0; i < childrenLen; i++) {
          // B50-ZK-381: Menu scrolling bug
          // child width may be larger than body.offsetWidth
          if (children[i].offsetLeft >= currScrollLeft || children[i].offsetLeft + (children[i].offsetWidth - body.offsetWidth) >= currScrollLeft) {
            var preChild = children[i].previousSibling;
            if (!preChild) return;
            movePos = preChild.offsetLeft;
            if (isNaN(movePos)) return;
            this._runId = setInterval(function () {
              if (!_this._moveTo(body, movePos)) {
                _this._afterMove();
              }
            }, 10);
            return;
          }
        }
        break;
      case 'right':
        var currRight = currScrollLeft + body.offsetWidth;
        for (var i = 0; i < childrenLen; i++) {
          var currChildRight = children[i].offsetLeft + children[i].offsetWidth;
          if (currChildRight > currRight) {
            movePos = currScrollLeft + (currChildRight - currRight);
            if (isNaN(movePos)) return;
            this._runId = setInterval(function () {
              if (!_this._moveTo(body, movePos)) {
                _this._afterMove();
              }
            }, 10);
            return;
          }
        }
        break;
    }
  };
  /** @internal */
  Menubar.prototype._moveTo = function (body, moveDest) {
    var currPos = this._bodyScrollLeft;
    if (currPos == moveDest) return false;
    var step = 5,
      delta = currPos > moveDest ? -step : step,
      setTo = currPos + delta;
    if (setTo < moveDest && delta < 0 || setTo > moveDest && delta > 0) setTo = moveDest;
    this._fixBodyScrollLeft(setTo);
    return true;
  };
  /** @internal */
  Menubar.prototype._afterMove = function () {
    clearInterval(this._runId);
    this._runId = undefined;
  };
  /** @internal */
  Menubar.prototype.insertChildHTML_ = function (child, before, desktop) {
    var vert = this.isVertical();
    if (before) jq(before.$n_()).before( /*safe*/this.encloseChildHTML_({
      child: child,
      vertical: vert
    }));else jq(this.$n_('cave')).append( /*safe*/this.encloseChildHTML_({
      child: child,
      vertical: vert
    }));
    child.bind(desktop);
  };
  /** @internal */
  Menubar.prototype.removeChildHTML_ = function (child, ignoreDom) {
    _super.prototype.removeChildHTML_.call(this, child, ignoreDom);
  };
  /** @internal */
  Menubar.prototype.encloseChildHTML_ = function (opts) {
    var _a;
    var out = (_a = opts.out) !== null && _a !== void 0 ? _a : new zk.Buffer(),
      child = opts.child;
    child.redraw(out);
    if (!opts.out) return out.join('');
  };
  //Closes all menupopup when mouse is moved out
  /** @internal */
  Menubar.prototype._closeOnOut = function () {
    var _this = this;
    if (this._autodrop && !zul.Widget.getOpenTooltip())
      //dirty fix: don't auto close if tooltip shown
      setTimeout(function () {
        return _closeOnOut(_this);
      }, 200);
  };
  /**
   * @returns whether it is a vertical menubar.
   * @since 9.5.0
   */
  Menubar.prototype.isVertical = function () {
    return 'vertical' == this.getOrient();
  };
  /** @internal */
  Menubar.prototype.doKeyDown_ = function (evt) {
    var direction = 0,
      isVertical = this.isVertical(),
      currentTarget = evt.target;
    switch (evt.key) {
      case 'ArrowLeft':
        if (!isVertical) direction = -1;
        break;
      case 'ArrowUp':
        if (isVertical) direction = -1;
        break;
      case 'ArrowRight':
        if (!isVertical) direction = 1;
        break;
      case 'ArrowDown':
        if (isVertical) direction = 1;
        break;
    }
    if (direction && currentTarget) {
      var target = direction < 0 ? this._getPrevVisibleMenuTarget(currentTarget) : this._getNextVisibleMenuTarget(currentTarget);
      if (target) target.focus();
      evt.stop();
    }
    _super.prototype.doKeyDown_.call(this, evt);
  };
  /** @internal */
  Menubar.prototype._getPrevVisibleMenuTarget = function (currentTarget) {
    var prev = currentTarget.previousSibling;
    if (!prev) {
      prev = this.lastChild;
    }
    return prev ? this._prevVisibleMenu(prev) : undefined;
  };
  /** @internal */
  Menubar.prototype._getNextVisibleMenuTarget = function (currentTarget) {
    var next = currentTarget.nextSibling;
    if (!next) {
      next = this.firstChild;
    }
    return next ? this._nextVisibleMenu(next) : undefined;
  };
  /** @internal */
  Menubar.prototype._nextVisibleMenu = function (menu) {
    for (var m = menu; m; m = m.nextSibling) {
      if (Menubar_1._isActiveItem(m)) return m;
    }
    if (this.firstChild == menu) return menu;
    return this._nextVisibleMenu(this.firstChild);
  };
  /** @internal */
  Menubar.prototype._prevVisibleMenu = function (menu) {
    for (var m = menu; m; m = m.previousSibling) {
      if (this.$class._isActiveItem(m)) return m;
    }
    if (this.lastChild == menu) return menu;
    return this._prevVisibleMenu(this.lastChild);
  };
  /** @internal */
  Menubar._isActiveItem = function (wgt) {
    return wgt.isVisible() && (wgt instanceof zul.menu.Menu || wgt instanceof zul.menu.Menuitem) && !wgt.isDisabled();
  };
  var Menubar_1;
  Menubar = Menubar_1 = __decorate([zk.WrapClass('zul.menu.Menubar')], Menubar);
  return Menubar;
}(zul.Widget);
exports.Menubar = Menubar;
if (!window.zul) window.zul = {};
if (!window.zul.menu) window.zul.menu = {};
if (!window.zul.menu.Menubar) window.zul.menu.Menubar = {};
window.zul.menu.Menubar._ = {
  _closeOnOut: _closeOnOut,
  Menubar: Menubar
};

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/menu/Menuitem.ts":
/*!************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/menu/Menuitem.ts ***!
  \************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Menuitem = void 0;
/* Menuitem.ts

    Purpose:

    Description:

    History:
        Thu Jan 15 09:02:33     2009, Created by jumperchen

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
function _initUpld(wgt) {
  zWatch.listen({
    onShow: wgt
  });
  var v = wgt._upload;
  if (v) wgt._uplder = new zul.Upload(wgt, wgt._getUploadRef(), v);
}
function _cleanUpld(wgt) {
  var v = wgt._uplder;
  if (v) {
    zWatch.unlisten({
      onShow: wgt
    });
    wgt._uplder = undefined;
    v.destroy();
  }
}
/**
 * A single choice in a {@link Menupopup} element.
 * It acts much like a button but it is rendered on a menu.
 *
 * @defaultValue {@link getZclass}: z-menuitem.
 */
var Menuitem = /** @class */function (_super) {
  __extends(Menuitem, _super);
  function Menuitem() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._value = '';
    /** @internal */
    _this._topmost = false;
    return _this;
  }
  Menuitem_1 = Menuitem;
  /**
   * @returns whether the check mark shall be displayed in front of each item.
   * @defaultValue `false`.
   */
  Menuitem.prototype.isCheckmark = function () {
    return !!this._checkmark;
  };
  /**
   * Sets whether the check mark shall be displayed in front of each item.
   */
  Menuitem.prototype.setCheckmark = function (checkmark, opts) {
    var o = this._checkmark;
    this._checkmark = checkmark;
    if (o !== checkmark || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.rerender();
    }
    return this;
  };
  /**
   * @returns whether it is disabled.
   * @defaultValue `false`.
   */
  Menuitem.prototype.isDisabled = function () {
    return !!this._disabled;
  };
  /**
   * Sets whether it is disabled.
   */
  Menuitem.prototype.setDisabled = function (disabled, opts) {
    var o = this._disabled;
    // eslint-disable-next-line zk/preferStrictBooleanType
    var value = disabled;
    //B60-ZK-1176
    // Autodisable should not re-enable when setDisabled(true) is called during onClick
    if (opts === null || opts === void 0 ? void 0 : opts.adbs)
      // called from zul.wgt.ADBS.autodisable
      this._adbs = true; // Start autodisabling
    else if (!opts || opts.adbs === undefined)
      // called somewhere else (including server-side)
      this._adbs = false; // Stop autodisabling
    if (!value) {
      if (this._adbs)
        // autodisable is still active, enable allowed
        this._adbs = false;
        // eslint-disable-next-line @typescript-eslint/no-unnecessary-boolean-literal-compare
      else if (opts && opts.adbs === false)
        // ignore re-enable by autodisable mechanism
        value = this._disabled;
    }
    this._disabled = value;
    if (o !== value || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.rerender((opts === null || opts === void 0 ? void 0 : opts.skip) ? -1 : 0); //bind and unbind
    }
    return this;
  };
  /**
   * @returns the href.
   * @defaultValue `null`. If null, the button has no function unless you
   * specify the onClick handler.
   */
  Menuitem.prototype.getHref = function () {
    return this._href;
  };
  /**
   * Sets the href.
   */
  Menuitem.prototype.setHref = function (href, opts) {
    var o = this._href;
    this._href = href;
    if (o !== href || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.rerender();
    }
    return this;
  };
  /**
   * @returns the value.
   * @defaultValue `""`.
   */
  Menuitem.prototype.getValue = function () {
    return this._value;
  };
  /**
   * Sets the value.
   */
  Menuitem.prototype.setValue = function (value) {
    this._value = value;
    return this;
  };
  /**
   * @returns whether it is checked.
   * @defaultValue `false`.
   */
  Menuitem.prototype.isChecked = function () {
    return !!this._checked;
  };
  /**
   * Sets whether it is checked.
   * <p> This only applies when {@link isCheckmark} = true.
   */
  Menuitem.prototype.setChecked = function (checked, opts) {
    var o = this._checked;
    this._checked = checked;
    if (o !== checked || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (checked) this._checkmark = checked;
      var n = this.$n();
      if (n && !this.isTopmost() && !this.getImage()) {
        var $n = jq(n);
        $n[checked ? 'addClass' : 'removeClass'](this.$s('checked'));
        if (this._checkmark) $n.addClass(this.$s('checkable'));
      }
    }
    return this;
  };
  /**
   * @returns whether the menuitem check mark will update each time the menu item is selected.
   * @defaultValue `false`.
   */
  Menuitem.prototype.isAutocheck = function () {
    return !!this._autocheck;
  };
  /**
   * Sets whether the menuitem check mark will update each time the menu item is selected.
   * <p> This only applies when {@link isCheckmark} = true.
   */
  Menuitem.prototype.setAutocheck = function (autocheck) {
    this._autocheck = autocheck;
    return this;
  };
  /**
   * @returns the target frame or window.
   * <p>Note: it is useful only if href ({@link setHref}) is specified
   * (i.e., use the onClick listener).
   * @defaultValue `null`.
   */
  Menuitem.prototype.getTarget = function () {
    return this._target;
  };
  /**
   * Sets the target frame or window.
   * @param target - the name of the frame or window to hyperlink.
   */
  Menuitem.prototype.setTarget = function (target, opts) {
    var o = this._target;
    this._target = target;
    if (o !== target || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var anc = this.$n('a');
      if (anc) {
        if (this.isTopmost()) anc = anc.parentNode;
        anc.target = this._target;
      }
    }
    return this;
  };
  /**
   * @returns a list of component IDs that shall be disabled when the user
   * clicks this menuitem.
   *
   * <p>To represent the menuitem itself, the developer can specify `self`.
   * For example, `<menuitem id="ok" autodisable="self,cancel"/>`
   * is the same as `<menuitem id="ok" autodisable="ok,cancel"/>`
   * that will disable
   * both the ok and cancel menuitem when an user clicks it.
   *
   * <p>The menuitem being disabled will be enabled automatically
   * once the client receives a response from the server.
   * In other words, the server doesn't notice if a menuitem is disabled
   * with this method.
   *
   * <p>However, if you prefer to enable them later manually, you can
   * prefix with '+'. For example,
   * `<menuitem id="ok" autodisable="+self,+cancel"/>`
   *
   * <p>Then, you have to enable them manually such as
   * ```ts
   * if (something_happened) {
   *  ok.setDisabled(false);
   *  cancel.setDisabled(false);
   * }
   * ```
   *
   * @defaultValue `null`.
   * @since 5.0.7
   */
  Menuitem.prototype.getAutodisable = function () {
    return this._autodisable;
  };
  /**
   * Sets whether to disable the button after the user clicks it.
   * @since 5.0.7
   */
  Menuitem.prototype.setAutodisable = function (autodisable) {
    this._autodisable = autodisable;
    return this;
  };
  /**
   * @returns non-null if this button is used for file upload, or null otherwise.
   * Refer to {@link setUpload} for more details.
   */
  Menuitem.prototype.getUpload = function () {
    return this._upload;
  };
  /**
   * Sets the JavaScript class at the client to handle the upload if this
   * button is used for file upload.
   * @defaultValue `null`.
   *
   * @param upload - a JavaScript class to handle the file upload
   * at the client, or "true" if the default class is used,
   * or null or "false" to disable the file download (and then
   * this button behaves like a normal button).
   */
  Menuitem.prototype.setUpload = function (upload, opts) {
    var o = this._upload;
    this._upload = upload;
    if (o !== upload || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n();
      if (n) {
        _cleanUpld(this);
        if (upload && upload != 'false') _initUpld(this);
      }
    }
    return this;
  };
  /**
   * @returns the file(s) belongs to this button if any.
   * @since 10.0.0
   */
  Menuitem.prototype.getFile = function () {
    var _a;
    return (_a = this._uplder) === null || _a === void 0 ? void 0 : _a.getFile();
  };
  /**
   * @returns whether this is an top-level menu, i.e., not owning by another {@link Menupopup}.
   */
  Menuitem.prototype.isTopmost = function () {
    return this._topmost;
  };
  /** @internal */
  Menuitem.prototype.beforeParentChanged_ = function (newParent) {
    this._topmost = !!newParent && !(newParent instanceof zul.menu.Menupopup);
    _super.prototype.beforeParentChanged_.call(this, newParent);
  };
  /** @internal */
  Menuitem.prototype.domClass_ = function (no) {
    var /*safe*/scls = _super.prototype.domClass_.call(this, no);
    if (!no || !no.zclass) {
      var added = this.isDisabled() ? this.$s('disabled') : '';
      if (added) scls += (scls ? ' ' : '') + added;
      added = !this.getImage() && this.isCheckmark() ? this.$s('checkable') + (this.isChecked() ? ' ' + this.$s('checked') : '') : '';
      if (added) scls += (scls ? ' ' : '') + added;
    }
    return scls;
  };
  /** @internal */
  Menuitem.prototype.domContent_ = function () {
    var label = '<span class="' + this.$s('text') + '">' + zUtl.encodeXML(this.getLabel()) + '</span>',
      icon = '<i class="' + this.$s('icon') + ' z-icon-check" aria-hidden="true"></i>',
      img = this.getImage(),
      /*safe*/iconSclass = this.domIcon_();
    if (img) /*safe*/img = '<img src="' + /*safe*/img + '" class="' + this.$s('image') + '" align="absmiddle" alt="" aria-hidden="true" />' + (iconSclass ? ' ' + /*safe*/iconSclass : '');else {
      if (iconSclass) {
        img = iconSclass;
      } else {
        img = '<img ' + (this.isTopmost() ? 'style="display:none"' : '') + ' src="data:image/png;base64,R0lGODlhAQABAIAAAAAAAAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="' + this.$s('image') + '" align="absmiddle" alt="" aria-hidden="true" />';
      }
    }
    return DOMPurify.sanitize(img + (this.isAutocheck() || this.isCheckmark() ? icon : '') + label);
  };
  /**
   * @returns the {@link Menubar} that contains this menuitem, or null if not available.
   */
  Menuitem.prototype.getMenubar = function () {
    for (var p = this.parent; p; p = p.parent) if (p instanceof zul.menu.Menubar) return p;
    return undefined;
  };
  /** @internal */
  Menuitem.prototype._getRootMenu = function () {
    for (var p = this.parent; p; p = p.parent) if (p instanceof zul.menu.Menu && p.isTopmost()) return p;
    return undefined;
  };
  /** @internal */
  Menuitem.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    if (!this.isDisabled()) {
      var anc = this.$n_('a');
      if (this.isTopmost()) {
        this.domListen_(anc, 'onFocus', 'doFocus_').domListen_(anc, 'onBlur', 'doBlur_');
      }
      this.domListen_(anc, 'onMouseEnter').domListen_(anc, 'onMouseLeave');
      if (this._upload) _initUpld(this);
    }
  };
  /** @internal */
  Menuitem.prototype.unbind_ = function (skipper, after, keepRod) {
    if (!this.isDisabled()) {
      if (this._upload) _cleanUpld(this);
      var anc = this.$n_('a');
      if (this.isTopmost()) {
        this.domUnlisten_(anc, 'onFocus', 'doFocus_').domUnlisten_(anc, 'onBlur', 'doBlur_');
      }
      this.domUnlisten_(anc, 'onMouseEnter').domUnlisten_(anc, 'onMouseLeave');
    }
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /** @internal */
  Menuitem.prototype.doClick_ = function (evt, popupOnly /* For inheritance */) {
    if (this._disabled) evt.stop();else {
      if (!this._canActivate(evt)) return;
      if (!this._upload) zul.wgt.ADBS.autodisable(this);else if (!zk.chrome || evt.domTarget.type != 'file')
        //ZK-3089
        this._uplder.openFileDialog();
      var topmost = this.isTopmost(),
        anc = this.$n_('a');
      if (anc.href.startsWith('javascript:')) {
        if (this.isAutocheck()) {
          this.setChecked(!this.isChecked());
          this.fire('onCheck', this.isChecked());
        }
        this.fireX(evt);
        //ZK-2679: prevent default behavior when upload=false
        if (!this._upload)
          //if upload=true, it won't fire onbeforeunload in IE <= 10
          evt.stop(); //if we stop evt when upload=true, it won't open upload window in IE <= 10
      } else if (anc.href.toLowerCase().startsWith('mailto:')) {
        // ZK-2506
        var ifrm = jq.newFrame('mailtoFrame', anc.href, undefined);
        jq(ifrm).remove();
        evt.stop();
      } else {
        if (zk.gecko && topmost && this.$n_().id != anc.id) {
          zUtl.go(anc.href, {
            target: anc.target
          });
          evt.stop();
          // Bug #2154611 we shall eat the onclick event, if it is FF3.
        }
      }
      if (!topmost) {
        var ref;
        for (var p = this.parent; p; p = p.parent) {
          if (p instanceof zul.menu.Menupopup) {
            // if close the popup before choosing a file, the file chooser can't be triggered.
            if (!p.isOpen() || this._uplder || p._keepOpen /*Bug #2911385 && !this._popup*/) break;
            this._updateHoverImage(); // remove hover image
            ref = p._fakeParent;
            p.close({
              sendOnOpen: true
            });
          } else if (!(p instanceof zul.menu.Menu))
            //either menubar or non-menu*
            break;else p._updateHoverImage(); // remove parent Menu hover image
        }
        // regain the focus on the root menu
        if (!this.isRealVisible()) {
          var rootMenu = this._getRootMenu();
          if (rootMenu) rootMenu.focus();else if (ref) {
            // https://bugzilla.mozilla.org/show_bug.cgi?id=1220143
            if (zk.ff) setTimeout(function () {
              var currentFocus = zk.currentFocus;
              if (!currentFocus || !currentFocus.isRealVisible()) ref.focus();
            }, 200);else ref.focus();
          }
        }
      }
      var menubar;
      if (zk.webkit && (menubar = this.getMenubar()) && menubar._autodrop) menubar._noFloatUp = true;
      //_noFloatUp used in Menu.js to fix Bug 1852304
      _super.prototype.doClick_.call(this, evt, true);
    }
  };
  /** @internal */
  Menuitem.prototype.doKeyDown_ = function (evt) {
    if (this.isTopmost() && !this._disabled) {
      var key = evt.key;
      if (key == ' ' || key == 'Enter') {
        evt.stop();
        this.doClick_(new zk.Event(this, 'onClick', {}));
      }
    }
    _super.prototype.doKeyDown_.call(this, evt);
  };
  /** @internal */
  Menuitem.prototype._canActivate = function (evt) {
    return !this.isDisabled() && (!this.isTopmost() || !!this._uplder || jq.isAncestor(this.$n('a'), evt.domTarget));
  };
  /** @internal */
  Menuitem.prototype._getUploadRef = function () {
    return this.$n('a');
  };
  /** @internal */
  Menuitem.prototype._doMouseEnter = function (evt) {
    var isTopmost = this.isTopmost();
    if (zul.menu._nOpen || isTopmost) zWatch.fire('onFloatUp', this); //notify all
    if (!isTopmost && !this._disabled) {
      if (this.parent instanceof zul.menu.Menupopup) this.parent.removeAllChildrenActive_();
      this.$class._addActive(this, 'hover');
      this.focus();
    }
  };
  /** @internal */
  Menuitem.prototype._doMouseLeave = function (evt) {
    var isTopmost = this.isTopmost();
    if (!isTopmost && !this._disabled) {
      this.$class._rmActive(this);
    }
  };
  /** @internal */
  Menuitem.prototype.deferRedrawHTML_ = function (out) {
    var tag = this.isTopmost() ? 'td' : 'li';
    out.push('<', tag, this.domAttrs_({
      domClass: true
    }), ' class="z-renderdefer"></', tag, '>');
  };
  Menuitem.prototype.getImageNode = function () {
    if (!this._eimg && (this._image || this._hoverImage)) {
      var n = this.$n();
      if (n) this._eimg = this.$n_('a').firstChild;
    }
    return this._eimg;
  };
  // internal use only.
  /** @internal */
  Menuitem.prototype.getAnchor_ = function () {
    return this.$n('a');
  };
  /** @internal */
  Menuitem.prototype.focus_ = function (timeout) {
    if (zk(this.getAnchor_()).focus(timeout)) {
      return true;
    }
    return _super.prototype.focus_.call(this, timeout);
  };
  /** @internal */
  Menuitem._isActive = function (wgt) {
    return jq(wgt.$n_()).hasClass(wgt.$s('hover'));
  };
  /** @internal */
  Menuitem._addActive = function (wgt, type) {
    var top = wgt.isTopmost();
    jq(wgt.$n_()).addClass(wgt.$s(type));
    if (!top && wgt.parent instanceof zul.menu.Menupopup) {
      var parentMenupopup = wgt.parent;
      parentMenupopup.addActive_(wgt);
      if (parentMenupopup.parent instanceof zul.menu.Menu) this._addActive(parentMenupopup.parent, type);
    }
  };
  /** @internal */
  Menuitem._rmActive = function (wgt) {
    return jq(wgt.$n_()).removeClass(wgt.$s('hover')).removeClass(wgt.$s('focus'));
  };
  Menuitem.prototype.onShow = function () {
    if (this._uplder) this._uplder.sync();
  };
  var Menuitem_1;
  Menuitem = Menuitem_1 = __decorate([zk.WrapClass('zul.menu.Menuitem')], Menuitem);
  return Menuitem;
}(zul.LabelImageWidget);
exports.Menuitem = Menuitem;
if (!window.zul) window.zul = {};
if (!window.zul.menu) window.zul.menu = {};
if (!window.zul.menu.Menuitem) window.zul.menu.Menuitem = {};
window.zul.menu.Menuitem._ = {
  _initUpld: _initUpld,
  _cleanUpld: _cleanUpld,
  Menuitem: Menuitem
};

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/menu/Menupopup.ts":
/*!*************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/menu/Menupopup.ts ***!
  \*************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports._nOpen = exports.Menupopup = void 0;
/* Menupopup.ts

    Purpose:

    Description:

    History:
        Thu Jan 15 09:02:34     2009, Created by jumperchen

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
function _getMenu(wgt) {
  var p = wgt.parent;
  return p instanceof zul.menu.Menu ? p : undefined;
}
function _getRootMenu(wgt) {
  for (var w = wgt; w && (w = _getMenu(w)); w = w.parent) {
    if (w.isTopmost()) return w;
  }
  return undefined;
}
//child must be _currentChild()
function _prevChild(popup, child) {
  var $menubar = zul.menu.Menubar;
  if (child) while (child = child.previousSibling) if ($menubar._isActiveItem(child)) {
    popup._curIndex--;
    return child;
  }
  //return the last
  popup._curIndex = -1;
  for (var w = popup.firstChild; w; w = w.nextSibling) if ($menubar._isActiveItem(w)) {
    //return the first one
    child = w;
    popup._curIndex++;
  }
  return child;
}
//child must be _currentChild()
function _nextChild(popup, child) {
  var $menubar = zul.menu.Menubar;
  if (child) while (child = child.nextSibling) if ($menubar._isActiveItem(child)) {
    popup._curIndex++;
    return child;
  }
  //return the first
  for (var w = popup.firstChild; w; w = w.nextSibling) if ($menubar._isActiveItem(w)) {
    //return the first one
    popup._curIndex = 0;
    return w;
  }
}
function _indexOfVisibleMenu(popup, child) {
  var i = -1,
    $menubar = zul.menu.Menubar;
  for (var c = popup.firstChild; c; c = c.nextSibling) {
    // check active first (child may be inactive)
    if ($menubar._isActiveItem(c)) {
      i++;
    }
    if (c == child) return i;
  }
  return i;
}
function _activateNextMenu(menu) {
  var pp = menu.menupopup;
  if (pp) {
    pp._shallClose = false;
    if (!pp.isOpen()) {
      menu.focus();
      pp.open(undefined, undefined, undefined, {
        focusFirst: true,
        sendOnOpen: true,
        disableMask: true
      });
    }
  }
  menu.$class._addActive(menu, 'focus');
  zWatch.fire('onFloatUp', menu); //notify all
}
/**
 * A container used to display menus. It should be placed inside a
 * {@link Menu}.
 *
 * @defaultValue {@link getZclass}: z-menupopup.
 */
var Menupopup = /** @class */function (_super) {
  __extends(Menupopup, _super);
  function Menupopup() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._curIndex = -1;
    /** @internal */
    _this._keepOpen = false;
    return _this;
  }
  Menupopup_1 = Menupopup;
  Menupopup.prototype.zsync = function (opts) {
    _super.prototype.zsync.call(this, opts);
    if (!this._shadow) this._shadow = new zk.eff.Shadow(this.$n_());
    this._shadow.sync();
  };
  /** @internal */
  Menupopup.prototype._hideShadow = function () {
    if (this._shadow) this._shadow.hide();
  };
  /** @internal */
  Menupopup.prototype._syncPos = function () {
    var menu = _getMenu(this);
    if (menu) {
      var n = this.$n_(),
        m = menu.$n_(),
        $n = jq(n),
        $m = jq(m),
        nol = $n.offset().left,
        mol = $m.offset().left,
        nwd = $n.outerWidth(),
        mwd = $m.outerWidth(),
        mp = menu.parent,
        mb = menu.getMenubar(),
        ori = mb ? mb.getOrient() : '',
        calculateToRight = false,
        left = -1;
      // ZK-2356 should sync position after calling super.onResponse()
      if (menu.isTopmost() && ori == 'horizontal' && n) n.style.top = jq.px0(zk.parseInt(n.style.top));
      while (mp && !(mp instanceof zul.menu.Menupopup)) mp = mp.parent;
      // sync menupopup position according to parent menupopup if any,
      // once expected position exceed the border, reverse open direction.
      if (mp) {
        if (mp._reverseDirection) {
          // calculateToLeft
          var expectedLeft = mol - nwd,
            leftBorderExceeded = expectedLeft < 0,
            expectedLeft = leftBorderExceeded ? mol + mwd : expectedLeft,
            expectedRight = expectedLeft + nwd,
            viewportRight = jq.innerX() + jq.innerWidth();
          left = expectedRight > viewportRight ? viewportRight - nwd : expectedLeft;
          this._reverseDirection = !leftBorderExceeded;
        } else {
          calculateToRight = true;
        }
      }
      /* ZK-2040: should sync position
          * when the overlap between menu and menupopup is greater than 5px,
          * only check the overlap situation when parent menupopup does not exist
          */
      if (!mp && zk(n).isOverlapped(m, 1) && (mol + mwd - nol > 5 && ori != 'vertical' || nol < mol + mwd / 2 && ori == 'vertical')) {
        calculateToRight = true;
      }
      if (calculateToRight) {
        var expectedLeft = mol + mwd,
          expectedRight = expectedLeft + nwd,
          viewportRight = jq.innerX() + jq.innerWidth(),
          rightBorderExceeded = expectedRight > viewportRight,
          expectedLeft = rightBorderExceeded ? mol - nwd : expectedLeft;
        left = Math.max(expectedLeft, 0);
        this._reverseDirection = rightBorderExceeded;
      }
      if (left >= 0) {
        n.style.left = jq.px0(left);
      }
    }
  };
  Menupopup.prototype.close = function (opts) {
    if (this.isOpen()) zul.menu._nOpen--;
    _super.prototype.close.call(this, opts);
    jq(this.$n_()).hide(); // force to hide the element
    this._hideShadow();
    var menu;
    if ((menu = _getMenu(this)) && menu.isTopmost()) jq(menu.$n_()).removeClass(menu.$s('selected'));
    this.removeActive_();
    this.$class._rmActive(this);
  };
  Menupopup.prototype.open = function (ref, offset, position, opts) {
    if (!this.isOpen()) zul.menu._nOpen++;
    var menu;
    if (menu = _getMenu(this)) {
      if (!offset) {
        ref = menu.getAnchor_();
        if (!position) {
          if (menu.isTopmost()) position = menu.parent.getOrient() == 'vertical' ? 'end_before' : 'after_start';else position = 'end_before';
        }
      }
    }
    _super.prototype.open.call(this, ref, offset, position, opts || {
      sendOnOpen: true,
      disableMask: true
    });
    //open will fire onShow which invoke this.zsync()
    this._syncPos(); //ZK-1248: re-sync position if sub-menu is overlapped on parent menu
    // focus on the first menuitem
    if (opts && opts.focusFirst) {
      this.doKeyDown_(new zk.Event(this, 'onKeyDown', {
        keyCode: 40,
        key: 'ArrowDown'
      }));
    }
  };
  /** @internal */
  Menupopup.prototype.shallStackup_ = function () {
    return false;
  };
  // eslint-disable-next-line zk/javaStyleSetterSignature
  Menupopup.prototype.setTopmost = function () {
    var result = _super.prototype.setTopmost.call(this);
    this.zsync();
    return result;
  };
  Menupopup.prototype.onFloatUp = function (ctl, opts) {
    if (!this.isVisible()) return;
    var openInfo = this._openInfo;
    // F70-ZK-2049: If popup belongs to widget's ascendant then return.
    if (this._shallToggle && openInfo && opts && (opts.triggerByClick === undefined || openInfo[3].which == opts.triggerByClick && zUtl.isAncestor(this._openInfo[0], ctl.origin))) {
      return;
    }
    this._doFloatUp(ctl);
  };
  /** @internal */
  Menupopup.prototype._doFloatUp = function (ctl) {
    if (!this.isVisible()) return;
    var org = ctl.origin;
    if (this.parent.menupopup == this && !this.parent.isTopmost() && !this.parent.$class._isActive(this.parent, 'hover')) {
      this.close({
        sendOnOpen: true
      });
      return;
    }
    // check if org belongs to the popup
    for (var floatFound = false, wgt = org; wgt; wgt = wgt.parent) {
      if (wgt == this || wgt.menupopup == this && !this._shallClose) {
        if (!floatFound) this.setTopmost();
        return;
      }
      floatFound = floatFound || wgt.isFloating_();
    }
    // check if the popup is one of org's children
    if (org instanceof zk.Widget && org.ignoreDescendantFloatUp_(this)) {
      for (var floatFound = false, wgt = this; wgt = wgt.parent;) {
        if (wgt == org) {
          if (this._shallClose) break; //close it
          if (!floatFound) this.setTopmost();
          return;
        }
        floatFound = floatFound || wgt.isFloating_();
      }
      //No need to check _lastTarget since we have to close any other open menupopup
    }
    this.close({
      sendOnOpen: true
    });
  };
  Menupopup.prototype.onShow = function () {
    this.zsync();
    var anc = this.getAnchor_();
    if (anc) {
      if (zk(anc).isRealVisible()) {
        anc.focus();
        zk.currentFocus = this; //Bug 2807475: (IE only) s.t. _docMouseDown will focus later (since menupop becomes invisible)
      }
    }
    zk(this).redoCSS(-1, {
      'fixFontIcon': true
    });
  };
  Menupopup.prototype.onHide = function () {
    if (this.isOpen()) this.close();
    this._hideShadow();
  };
  /** @internal */
  Menupopup.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    zWatch.listen({
      onHide: this,
      onResponse: this
    });
    var n = this.$n_();
    n.addEventListener('mouseenter', this.proxy(this._doMouseEnter));
    n.addEventListener('mouseleave', this.proxy(this._doMouseLeave));
    if (!zk.css3) jq.onzsync(this);
  };
  /** @internal */
  Menupopup.prototype.unbind_ = function (skipper, after, keepRod) {
    if (this.isOpen()) this.close();
    if (this._shadow) this._shadow.destroy();
    if (!zk.css3) jq.unzsync(this);
    this._shadow = undefined;
    zWatch.unlisten({
      onHide: this,
      onResponse: this
    });
    var n = this.$n_();
    n.removeEventListener('mouseleave', this.proxy(this._doMouseLeave));
    n.removeEventListener('mouseenter', this.proxy(this._doMouseEnter));
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  Menupopup.prototype.onResponse = function () {
    if (!this.isOpen()) return; // Bug 2950364
    this.zsync();
    _super.prototype.onResponse.call(this); //Bug #2870616
    this._syncPos(); // For Bug ZK-2160, resync position again after invoking supers.
  };
  /** @internal */
  Menupopup.prototype.doKeyDown_ = function (evt) {
    var w = this._currentChild(),
      menu,
      keyCode = evt.keyCode;
    switch (keyCode) {
      case 38: //UP
      case 40:
        //DOWN
        // UP: 1. jump to the previousSibling item
        // DOWN: 1. jump to the nextSibling item
        this.removeAllChildrenActive_();
        w = keyCode == 38 ? _prevChild(this, w) : _nextChild(this, w);
        if (w) {
          w.$class._addActive(w, 'focus'); // FIXME: type of w is inconsistent
          w.focus();
        }
        break;
      case 37:
        //LEFT
        // 1. close the contenthandler (like colorbox), if any
        // 2. close the menupopup and jump to the parent menu
        // 3. if in the topmost menu, then jump to the previous menu
        // 4. close it when not above scenario matched.
        if (w && w instanceof zul.menu.Menu && w._contentHandler && w._contentHandler.isOpen()) {
          w._contentHandler.onHide();
        } else if ((menu = _getMenu(this)) && !menu.isTopmost()) {
          this.close();
          menu.$class._addActive(menu, 'focus');
          var pp = menu.parent; // FIXME: type of pp is inconsistent
          if (pp) {
            pp.focus();
            pp._curIndex = _indexOfVisibleMenu(pp, menu);
          }
        } else {
          var root = _getRootMenu(this);
          if (root && (root = root._getPrevVisibleMenu())) _activateNextMenu(root);else {
            // the parent is not menu widget
            var ref = this._fakeParent;
            this.close();
            if (ref) ref.focus();
          }
        }
        break;
      case 39:
        //RIGHT
        // 1. Open the descendant menupopup if any
        // 2. jump to the next topmost menu
        if (w && w instanceof zul.menu.Menu && !w.isDisabled()) {
          w._togglePopup(true);
        } else {
          var root = _getRootMenu(this);
          if (root && (root = root._getNextVisibleMenu())) _activateNextMenu(root);
        }
        break;
      case 13:
        //ENTER
        // 1. fire onClick event when target is Menuitem
        // 2. toggle menupopup when target is Menu
        // 3. fire onClick event if target is Menu and clickable
        if (w && w instanceof zul.menu.Menuitem) {
          //{} for emulate as onClick, escape the checking data == null at serverside
          w.doClick_(new zk.Event(w, 'onClick', {}));
          zWatch.fire('onFloatUp', w); //notify all
          this.close({
            sendOnOpen: true
          });
        } else if (w && w instanceof zul.menu.Menu) {
          w._togglePopup(true);
        } else {
          if (menu = _getMenu(this)) {
            this.close();
            if (menu.isTopmost()) {
              menu.focus();
            } else {
              menu.$class._addActive(menu, 'focus');
              var pp = menu.parent;
              if (pp) {
                pp.focus();
              }
            }
          }
        }
        break;
      case 27:
        //ESC
        // 1. close the menupopup, if any
        // 2. close the contenthandler, if any
        if (menu = _getMenu(this)) {
          if (menu.isTopmost()) {
            this.close();
            menu.focus();
          } else {
            var content = menu._contentHandler;
            if (content && content.isOpen()) {
              content.onHide();
            } else {
              this.close();
              menu.$class._addActive(menu, 'focus');
              var pp = menu.parent;
              if (pp) {
                pp.focus();
              }
            }
          }
        } else {
          // the parent is not menu widget
          var ref = this._fakeParent;
          this.close({
            sendOnOpen: true
          });
          if (ref) ref.focus();
        }
        break;
      case 9:
        // TAB
        // 1. close the menupopup and then it will jump to next menu, if any.
        // Note: don't stop the event.
        var root = _getRootMenu(this);
        if (root) {
          // a trick way to jump to the next menu.
          root.focus_(undefined, false);
        }
        this.close();
        break;
    }
    if (keyCode != 9 && keyCode != 27)
      // TAB && ESC
      evt.stop(); // Bug ZK-442
    _super.prototype.doKeyDown_.call(this, evt);
  };
  /** @internal */
  Menupopup.prototype.doClick_ = function (evt, popupOnly) {
    // Prevent from closing the popup if being triggered by space key.
    // https://bugzilla.mozilla.org/show_bug.cgi?id=1220143
    if (evt.domTarget == this.getAnchor_()) evt.stop();
    _super.prototype.doClick_.call(this, evt, popupOnly);
  };
  /**
   * @returns the {@link Menubar} that contains this menuitem, or null if not available.
   * @since 5.0.5
   */
  Menupopup.prototype.getMenubar = function () {
    var p = this.parent;
    if (p) {
      if (p instanceof zul.menu.Menubar) return p;
      if (p instanceof zul.menu.Menu) return p.getMenubar();
    }
    return undefined;
  };
  /** @internal */
  Menupopup.prototype._doMouseEnter = function (evt) {
    var menubar = this.getMenubar();
    if (menubar) menubar._bOver = true;
    this._shallClose = false;
  };
  /** @internal */
  Menupopup.prototype._doMouseLeave = function (evt) {
    var menubar = this.getMenubar();
    if (menubar) {
      menubar._bOver = false;
      if (menubar._autodrop) menubar._closeOnOut();
    }
    // Don't remove if current active is menu (with a menupopup)
    if (!(this._currentChild() instanceof zul.menu.Menu)) this.removeActive_();
  };
  /**
   * Sets the current active item in this menupopup.
   * @param childIndex - the index of menupopup children
   * @since 8.6.0
   */
  // eslint-disable-next-line zk/javaStyleSetterSignature
  Menupopup.prototype.setActive = function (childIndex) {
    if (childIndex >= 0 && childIndex < this.nChildren) {
      var newCurrIndex = -1,
        $menubar = zul.menu.Menubar;
      for (var w = this.firstChild, i = 0, visibleIndex = 0; w; w = w.nextSibling, i++) {
        var isActive = $menubar._isActiveItem(w);
        if (childIndex === i && isActive) {
          newCurrIndex = visibleIndex;
          break;
        }
        if (isActive) visibleIndex++;
      }
      if (newCurrIndex >= 0) {
        // The item is eligible to be active
        this.removeActive_();
        this._curIndex = newCurrIndex;
        var target = this.getChildAt(childIndex);
        if (target) target.$class._addActive(target, 'hover');
      }
    }
    return this;
  };
  // internal use only.
  /** @internal */
  Menupopup.prototype.getAnchor_ = function () {
    return this.$n('a');
  };
  /** @internal */
  Menupopup.prototype.focus_ = function (timeout) {
    if (zk(this.getAnchor_()).focus(timeout)) {
      return true;
    }
    return _super.prototype.focus_.call(this, timeout);
  };
  /** @internal */
  Menupopup.prototype.addActive_ = function (wgt) {
    this._curIndex = _indexOfVisibleMenu(this, wgt);
  };
  /** @internal */
  Menupopup.prototype.removeActive_ = function () {
    var currentActive = this._currentChild();
    if (currentActive) {
      currentActive.$class._rmActive(currentActive);
      this._curIndex = -1;
    }
  };
  /** @internal */
  Menupopup.prototype.removeAllChildrenActive_ = function () {
    for (var child = this === null || this === void 0 ? void 0 : this.firstChild; child != undefined; child = child.nextSibling) {
      if (child instanceof zul.menu.Menuitem) {
        child.$class._rmActive(child);
      } else if (child instanceof zul.menu.Menu) {
        child.$class._rmActive(child);
        var pp = child.menupopup;
        if (pp === null || pp === void 0 ? void 0 : pp.isOpen()) {
          jq(child.$n_()).removeClass(child.$s('hover')).removeClass(child.$s('selected'));
          pp.close();
        }
      }
    }
  };
  /** @internal */
  Menupopup.prototype._currentChild = function () {
    var index = this._curIndex,
      $menubar = zul.menu.Menubar;
    if (index >= 0) {
      for (var w = this.firstChild, k = 0; w; w = w.nextSibling) if ($menubar._isActiveItem(w) && k++ == index) return w;
    }
    return undefined;
  };
  /** @internal */
  Menupopup._rmActive = function (wgt) {
    if (wgt.parent instanceof zul.menu.Menu) {
      wgt.parent.constructor._rmActive(wgt.parent);
    }
  };
  var Menupopup_1;
  Menupopup = Menupopup_1 = __decorate([zk.WrapClass('zul.menu.Menupopup')], Menupopup);
  return Menupopup;
}(zul.wgt.Popup);
exports.Menupopup = Menupopup;
exports._nOpen = 0;
if (!window.zul) window.zul = {};
if (!window.zul.menu) window.zul.menu = {};
if (!window.zul.menu.Menupopup) window.zul.menu.Menupopup = {};
window.zul.menu.Menupopup._ = {
  _getMenu: _getMenu,
  _getRootMenu: _getRootMenu,
  _prevChild: _prevChild,
  _nextChild: _nextChild,
  _indexOfVisibleMenu: _indexOfVisibleMenu,
  _activateNextMenu: _activateNextMenu,
  Menupopup: Menupopup
};

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/menu/Menuseparator.ts":
/*!*****************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/menu/Menuseparator.ts ***!
  \*****************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Menuseparator = void 0;
/* Menuseparator.ts

    Purpose:

    Description:

    History:
        Thu Jan 15 09:02:35     2009, Created by jumperchen

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * Used to create a separator between menu items.
 *
 * @defaultValue {@link getZclass}: z-menuseparator.
 */
var Menuseparator = /** @class */function (_super) {
  __extends(Menuseparator, _super);
  function Menuseparator() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  /**
   * @returns whether parent is a {@link Menupopup}
   */
  Menuseparator.prototype.isPopup = function () {
    return !!this.parent && this.parent instanceof zul.menu.Menupopup;
  };
  /**
   * @returns the {@link Menubar} that contains this menuseparator, or null if not available.
   */
  Menuseparator.prototype.getMenubar = function () {
    for (var p = this.parent; p; p = p.parent) if (p instanceof zul.menu.Menubar) return p;
    return undefined;
  };
  /** @internal */
  Menuseparator.prototype.doMouseOver_ = function (evt) {
    if (zul.menu._nOpen) zWatch.fire('onFloatUp', this); //notify all
    _super.prototype.doMouseOver_.call(this, evt);
  };
  Menuseparator = __decorate([zk.WrapClass('zul.menu.Menuseparator')], Menuseparator);
  return Menuseparator;
}(zul.Widget);
exports.Menuseparator = Menuseparator;
if (!window.zul) window.zul = {};
if (!window.zul.menu) window.zul.menu = {};
if (!window.zul.menu.Menuseparator) window.zul.menu.Menuseparator = {};
window.zul.menu.Menuseparator._ = {
  Menuseparator: Menuseparator
};

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/menu/index.ts":
/*!*********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/menu/index.ts ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __exportStar = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__exportStar"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = {};
__exportStar(__webpack_require__(/*! ./Menubar */ "./zul/src/main/resources/web/js/zul/menu/Menubar.ts"), exports);
__exportStar(__webpack_require__(/*! ./Menu */ "./zul/src/main/resources/web/js/zul/menu/Menu.ts"), exports);
__exportStar(__webpack_require__(/*! ./Menuitem */ "./zul/src/main/resources/web/js/zul/menu/Menuitem.ts"), exports);
__exportStar(__webpack_require__(/*! ./Menuseparator */ "./zul/src/main/resources/web/js/zul/menu/Menuseparator.ts"), exports);
__exportStar(__webpack_require__(/*! ./Menupopup */ "./zul/src/main/resources/web/js/zul/menu/Menupopup.ts"), exports);

/***/ }),

/***/ "./node_modules/tslib/tslib.es6.js":
/*!*****************************************!*\
  !*** ./node_modules/tslib/tslib.es6.js ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __addDisposableResource: function() { return /* binding */ __addDisposableResource; },
/* harmony export */   __assign: function() { return /* binding */ __assign; },
/* harmony export */   __asyncDelegator: function() { return /* binding */ __asyncDelegator; },
/* harmony export */   __asyncGenerator: function() { return /* binding */ __asyncGenerator; },
/* harmony export */   __asyncValues: function() { return /* binding */ __asyncValues; },
/* harmony export */   __await: function() { return /* binding */ __await; },
/* harmony export */   __awaiter: function() { return /* binding */ __awaiter; },
/* harmony export */   __classPrivateFieldGet: function() { return /* binding */ __classPrivateFieldGet; },
/* harmony export */   __classPrivateFieldIn: function() { return /* binding */ __classPrivateFieldIn; },
/* harmony export */   __classPrivateFieldSet: function() { return /* binding */ __classPrivateFieldSet; },
/* harmony export */   __createBinding: function() { return /* binding */ __createBinding; },
/* harmony export */   __decorate: function() { return /* binding */ __decorate; },
/* harmony export */   __disposeResources: function() { return /* binding */ __disposeResources; },
/* harmony export */   __esDecorate: function() { return /* binding */ __esDecorate; },
/* harmony export */   __exportStar: function() { return /* binding */ __exportStar; },
/* harmony export */   __extends: function() { return /* binding */ __extends; },
/* harmony export */   __generator: function() { return /* binding */ __generator; },
/* harmony export */   __importDefault: function() { return /* binding */ __importDefault; },
/* harmony export */   __importStar: function() { return /* binding */ __importStar; },
/* harmony export */   __makeTemplateObject: function() { return /* binding */ __makeTemplateObject; },
/* harmony export */   __metadata: function() { return /* binding */ __metadata; },
/* harmony export */   __param: function() { return /* binding */ __param; },
/* harmony export */   __propKey: function() { return /* binding */ __propKey; },
/* harmony export */   __read: function() { return /* binding */ __read; },
/* harmony export */   __rest: function() { return /* binding */ __rest; },
/* harmony export */   __runInitializers: function() { return /* binding */ __runInitializers; },
/* harmony export */   __setFunctionName: function() { return /* binding */ __setFunctionName; },
/* harmony export */   __spread: function() { return /* binding */ __spread; },
/* harmony export */   __spreadArray: function() { return /* binding */ __spreadArray; },
/* harmony export */   __spreadArrays: function() { return /* binding */ __spreadArrays; },
/* harmony export */   __values: function() { return /* binding */ __values; }
/* harmony export */ });
/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise, SuppressedError, Symbol */

var extendStatics = function(d, b) {
    extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
    return extendStatics(d, b);
};

function __extends(d, b) {
    if (typeof b !== "function" && b !== null)
        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
    extendStatics(d, b);
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    }
    return __assign.apply(this, arguments);
}

function __rest(s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
}

function __decorate(decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
}

function __param(paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
}

function __esDecorate(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};

function __runInitializers(thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};

function __propKey(x) {
    return typeof x === "symbol" ? x : "".concat(x);
};

function __setFunctionName(f, name, prefix) {
    if (typeof name === "symbol") name = name.description ? "[".concat(name.description, "]") : "";
    return Object.defineProperty(f, "name", { configurable: true, value: prefix ? "".concat(prefix, " ", name) : name });
};

function __metadata(metadataKey, metadataValue) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
}

function __awaiter(thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

function __generator(thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
}

var __createBinding = Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
});

function __exportStar(m, o) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p)) __createBinding(o, m, p);
}

function __values(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}

function __read(o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
}

/** @deprecated */
function __spread() {
    for (var ar = [], i = 0; i < arguments.length; i++)
        ar = ar.concat(__read(arguments[i]));
    return ar;
}

/** @deprecated */
function __spreadArrays() {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
}

function __spreadArray(to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
}

function __await(v) {
    return this instanceof __await ? (this.v = v, this) : new __await(v);
}

function __asyncGenerator(thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
    function verb(n) { if (g[n]) i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
}

function __asyncDelegator(o) {
    var i, p;
    return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
    function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: false } : f ? f(v) : v; } : f; }
}

function __asyncValues(o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
}

function __makeTemplateObject(cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};

var __setModuleDefault = Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
};

function __importStar(mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
}

function __importDefault(mod) {
    return (mod && mod.__esModule) ? mod : { default: mod };
}

function __classPrivateFieldGet(receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
}

function __classPrivateFieldSet(receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
}

function __classPrivateFieldIn(state, receiver) {
    if (receiver === null || (typeof receiver !== "object" && typeof receiver !== "function")) throw new TypeError("Cannot use 'in' operator on non-object");
    return typeof state === "function" ? receiver === state : state.has(receiver);
}

function __addDisposableResource(env, value, async) {
    if (value !== null && value !== void 0) {
        if (typeof value !== "object" && typeof value !== "function") throw new TypeError("Object expected.");
        var dispose;
        if (async) {
            if (!Symbol.asyncDispose) throw new TypeError("Symbol.asyncDispose is not defined.");
            dispose = value[Symbol.asyncDispose];
        }
        if (dispose === void 0) {
            if (!Symbol.dispose) throw new TypeError("Symbol.dispose is not defined.");
            dispose = value[Symbol.dispose];
        }
        if (typeof dispose !== "function") throw new TypeError("Object not disposable.");
        env.stack.push({ value: value, dispose: dispose, async: async });
    }
    else if (async) {
        env.stack.push({ async: true });
    }
    return value;
}

var _SuppressedError = typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
    var e = new Error(message);
    return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
};

function __disposeResources(env) {
    function fail(e) {
        env.error = env.hasError ? new _SuppressedError(e, env.error, "An error was suppressed during disposal.") : e;
        env.hasError = true;
    }
    function next() {
        while (env.stack.length) {
            var rec = env.stack.pop();
            try {
                var result = rec.dispose && rec.dispose.call(rec.value);
                if (rec.async) return Promise.resolve(result).then(next, function(e) { fail(e); return next(); });
            }
            catch (e) {
                fail(e);
            }
        }
        if (env.hasError) throw env.error;
    }
    return next();
}

/* harmony default export */ __webpack_exports__["default"] = ({
    __extends: __extends,
    __assign: __assign,
    __rest: __rest,
    __decorate: __decorate,
    __param: __param,
    __metadata: __metadata,
    __awaiter: __awaiter,
    __generator: __generator,
    __createBinding: __createBinding,
    __exportStar: __exportStar,
    __values: __values,
    __read: __read,
    __spread: __spread,
    __spreadArrays: __spreadArrays,
    __spreadArray: __spreadArray,
    __await: __await,
    __asyncGenerator: __asyncGenerator,
    __asyncDelegator: __asyncDelegator,
    __asyncValues: __asyncValues,
    __makeTemplateObject: __makeTemplateObject,
    __importStar: __importStar,
    __importDefault: __importDefault,
    __classPrivateFieldGet: __classPrivateFieldGet,
    __classPrivateFieldSet: __classPrivateFieldSet,
    __classPrivateFieldIn: __classPrivateFieldIn,
    __addDisposableResource: __addDisposableResource,
    __disposeResources: __disposeResources,
});


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./zul/src/main/resources/web/js/zul/menu/index.ts");
/******/ 	var __webpack_export_target__ = window;
/******/ 	var __webpack_exports_export__ = __webpack_exports__["default"];
/******/ 	for(var i in __webpack_exports_export__) __webpack_export_target__[i] = __webpack_exports_export__[i];
/******/ 	if(__webpack_exports_export__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;